/*-------------------------------------------
   ժOlW1HzTO_`
   1Hzs8051 INT0AH_覡q8051
   CBUILTIN_LED{G@

   2024/02/07
--------------------------------------------*/
#include <REG52.H>

sbit BUILTIN_LED  = P1^4;    //1:OFF  0:ON

//========== Interrupt Function ==============================================
unsigned char ex0_isr_counter = 0;

void ex0_isr(void) interrupt 0
{
  ex0_isr_counter = 1;   // Increment the counter
}
//============================================================================
void wait (void)  {      /* wait function */
  unsigned int i;
  for (i = 0; i < 100; i++)
    ;         /* only to delay for LED flashes */
}

//============================================================================
void main (void)
{
  unsigned int i;
  
  /*-----------------------------------------------
  Configure INT0 (external interrupt 0) to generate
  an interrupt on the falling-edge of /INT0 (P3.2).
  Enable the EX0 interrupt and then enable the
  global interrupt flag.
  -----------------------------------------------*/
  IT0 = 1;   // Configure interrupt 0 for falling edge on /INT0 (P3.2)
  EX0 = 1;   // Enable EX0 Interrupt
  EA = 1;    // Enable Global Interrupt Flag
  
  while (1)
  {
    if(ex0_isr_counter == 1){
      
      ex0_isr_counter = 0; 
      
      BUILTIN_LED = 0x00;          // Output to LED Port 
      for (i = 0; i < 80; i++)  {  // Delay for 10000 Counts 
       wait ();                    // call wait function 
      } 
      BUILTIN_LED = 0x01;          // Output to LED Port 
      
    }
  }
}




